/**
 * Copyright (C) 2015 by Liangliang Nan (liangliang.nan@gmail.com)
 * https://3d.bk.tudelft.nl/liangliang/
 *
 * This file is part of Easy3D. If it is useful in your research/work,
 * I would be grateful if you show your appreciation by citing it:
 * ------------------------------------------------------------------
 *      Liangliang Nan.
 *      Easy3D: a lightweight, easy-to-use, and efficient C++
 *      library for processing and rendering 3D data. 2018.
 * ------------------------------------------------------------------
 * Easy3D is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 3
 * as published by the Free Software Foundation.
 *
 * Easy3D is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "viewer.h"

using namespace easy3d;


void ImagingViewer::imaging(
        double &fx, double &fy,   /// the focal lengths
        double &cx, double &cy,   /// the principal point
        Matrix33 &R,   /// rotation of the camera
        Vector3D &t,   /// translation of the camera
        std::vector<Vector3D> &points_3d    /// 3D points
) const {
    /// Here are the camera intrinsic parameters
    fx = 1000;
    fy = 1000;
    cx = 320;
    cy = 240;

    /// Let's assume an ideal camera (i.e., no skew distortion)
    const double skew = 0.0;

    /// Here are a set of 3D object points stored in an array
    points_3d = {
            {-0.348852,    0.175479,    1.73528},
            {-0.313034,    0.173785,    1.7376},
            {-0.277596,    0.170583,    1.7302},
            {-0.243198,    0.171073,    1.72774},
            {-0.207964,    0.177639,    1.74309},
            {-0.174083,    0.173894,    1.73592},
            {-0.138822,    0.173437,    1.73528},
            {-0.102955,    0.173695,    1.73356},
            {-0.068094,    0.172172,    1.72787},
            {-0.0356642,   0.173275,    1.73669},
            {0.000736734,  0.174201,    1.73423},
            {0.0348842,    0.171669,    1.72232},
            {0.0720269,    0.173909,    1.73557},
            {0.100714,     0.170236,    1.71933},
            {0.135839,     0.17079,     1.72571},
            {0.172465,     0.1693,      1.72526},
            {0.209258,     0.174207,    1.73433},
            {0.243879,     0.167286,    1.71709},
            {0.277675,     0.170791,    1.72754},
            {0.309523,     0.169531,    1.7211},
            {0.352788,     0.175273,    1.74021},
            {-0.349916,    -0.139555,   1.74509},
            {-0.350831,    -0.106325,   1.74315},
            {-0.350131,    -0.0709978,  1.73972},
            {-0.349086,    -0.0349233,  1.74213},
            {-0.349382,    -0.00119185, 1.74321},
            {-0.345066,    0.03523,     1.74076},
            {-0.347354,    0.0701367,   1.74695},
            {-0.348501,    0.101721,    1.73134},
            {-0.349908,    0.143332,    1.74512},
            {0.351032,     -0.138395,   1.7349},
            {0.352048,     -0.103066,   1.74333},
            {0.350409,     -0.0684697,  1.73369},
            {0.347348,     -0.0377202,  1.72291},
            {0.344641,     -0.00252763, 1.72196},
            {0.348902,     0.0343321,   1.73348},
            {0.345272,     0.0662497,   1.71932},
            {0.345523,     0.101463,    1.72465},
            {0.346084,     0.137113,    1.72641},
            {-0.34911,     -0.17605,    1.74925},
            {-0.313193,    -0.172962,   1.74575},
            {-0.278944,    -0.174017,   1.74443},
            {-0.244861,    -0.174795,   1.74841},
            {-0.206175,    -0.174978,   1.7428},
            {-0.174196,    -0.174328,   1.74316},
            {-0.139243,    -0.175346,   1.73949},
            {-0.104009,    -0.175297,   1.73351},
            {-0.0668963,   -0.176712,   1.74034},
            {-0.0367043,   -0.175486,   1.73732},
            {0.00282982,   -0.174924,   1.73886},
            {0.0355087,    -0.176231,   1.73527},
            {0.070696,     -0.174843,   1.73568},
            {0.105046,     -0.174393,   1.74231},
            {0.139233,     -0.178323,   1.73173},
            {0.177767,     -0.174635,   1.74127},
            {0.209819,     -0.176051,   1.73303},
            {0.24819,      -0.173531,   1.74182},
            {0.277353,     -0.174265,   1.73297},
            {0.312613,     -0.175822,   1.72982},
            {0.351051,     -0.175369,   1.73506},
            {-0.349248,    0.17865,     2.09399},
            {-0.311473,    0.174677,    2.08284},
            {-0.279649,    0.17614,     2.09041},
            {-0.243796,    0.171984,    2.08119},
            {-0.206873,    0.173124,    2.07311},
            {-0.17434,     0.171658,    2.07354},
            {-0.141435,    0.174321,    2.08543},
            {-0.102233,    0.176632,    2.09453},
            {-0.0678909,   0.172731,    2.08319},
            {-0.0342135,   0.175079,    2.084},
            {-0.000979426, 0.169598,    2.07162},
            {0.0376033,    0.175466,    2.08317},
            {0.0740854,    0.175527,    2.08896},
            {0.107144,     0.16658,     2.07843},
            {0.138359,     0.168802,    2.06418},
            {0.171884,     0.173762,    2.07561},
            {0.212221,     0.176606,    2.08691},
            {0.241218,     0.168305,    2.05787},
            {0.276858,     0.173247,    2.07483},
            {0.313028,     0.171597,    2.08149},
            {0.347684,     0.171706,    2.07713},
            {-0.348618,    -0.141933,   2.08796},
            {-0.348956,    -0.107041,   2.10335},
            {-0.348596,    -0.0679049,  2.09436},
            {-0.348706,    -0.0351841,  2.09563},
            {-0.349069,    -0.00144128, 2.0801},
            {-0.347911,    0.0338976,   2.0907},
            {-0.347054,    0.0692102,   2.09107},
            {-0.349375,    0.10602,     2.09327},
            {-0.347119,    0.141347,    2.09563},
            {0.354432,     -0.134851,   2.08788},
            {0.355641,     -0.105909,   2.08892},
            {0.353343,     -0.0715576,  2.08994},
            {0.346852,     -0.038986,   2.06997},
            {0.348411,     -0.00237281, 2.07406},
            {0.343684,     0.0345877,   2.07183},
            {0.348701,     0.0670124,   2.07859},
            {0.348233,     0.101343,    2.07802},
            {0.352112,     0.140247,    2.08249},
            {-0.348323,    -0.175178,   2.08326},
            {-0.312406,    -0.173968,   2.09182},
            {-0.275578,    -0.174889,   2.08057},
            {-0.243225,    -0.174389,   2.09357},
            {-0.2101,      -0.175002,   2.08682},
            {-0.176409,    -0.177025,   2.0795},
            {-0.139838,    -0.174653,   2.08585},
            {-0.10522,     -0.175467,   2.08873},
            {-0.0678094,   -0.176699,   2.09209},
            {-0.0339212,   -0.173167,   2.09758},
            {0.00156691,   -0.175968,   2.08315},
            {0.0360564,    -0.178221,   2.08554},
            {0.0716477,    -0.174175,   2.08902},
            {0.106465,     -0.177767,   2.09256},
            {0.141228,     -0.176126,   2.08271},
            {0.176833,     -0.173753,   2.09343},
            {0.209936,     -0.17488,    2.08082},
            {0.24786,      -0.177134,   2.09202},
            {0.279191,     -0.175455,   2.08092},
            {0.310176,     -0.176414,   2.07904},
            {0.345119,     -0.172914,   2.07115},
            {-0.348956,    0.172713,    1.76638},
            {-0.349425,    0.176503,    1.77818},
            {-0.347805,    0.175025,    1.80785},
            {-0.348895,    0.175428,    1.84486},
            {-0.348552,    0.172387,    1.87324},
            {-0.346462,    0.17483,     1.90133},
            {-0.347476,    0.178684,    1.94968},
            {-0.350333,    0.17386,     1.98595},
            {-0.347188,    0.171499,    2.00665},
            {-0.348953,    0.174077,    2.04282},
            {0.347949,     0.171546,    1.7585},
            {0.345785,     0.169319,    1.75709},
            {0.350778,     0.175322,    1.8106},
            {0.345279,     0.170624,    1.82691},
            {0.345602,     0.168976,    1.86066},
            {0.346922,     0.170566,    1.89882},
            {0.342429,     0.170154,    1.91984},
            {0.349295,     0.16928,     1.97844},
            {0.346637,     0.172316,    2.00685},
            {0.344322,     0.172559,    2.03319},
            {-0.348979,    -0.175614,   1.76529},
            {-0.348712,    -0.174546,   1.77773},
            {-0.348626,    -0.174726,   1.81846},
            {-0.345911,    -0.173757,   1.84749},
            {-0.348481,    -0.174832,   1.88657},
            {-0.350836,    -0.175579,   1.92475},
            {-0.349956,    -0.175839,   1.94416},
            {-0.349562,    -0.173324,   1.99478},
            {-0.348931,    -0.176252,   2.02095},
            {-0.345604,    -0.174258,   2.06471},
            {0.352228,     -0.174178,   1.77861},
            {0.348831,     -0.174797,   1.77132},
            {0.349417,     -0.173973,   1.80186},
            {0.345738,     -0.174532,   1.83416},
            {0.353211,     -0.174745,   1.88734},
            {0.348359,     -0.178854,   1.90498},
            {0.348022,     -0.174317,   1.9485},
            {0.348747,     -0.173958,   1.98024},
            {0.351919,     -0.175899,   2.01191},
            {0.353392,     -0.175458,   2.06091}
    };

    /// Here are the camera extrinsic parameters
    /// Extrinsic parameters - rotation
    R = Matrix33(
            0.965151, -0.00207759, -0.261687,
            -0.066138, 0.96557, -0.251595,
            0.2532, 0.260135, 0.931783
    );
    /// Extrinsic parameters - translation
    t = Vector3D(0.676348, 0.630973, 0.380036);

    /// Let's build the 3 by 3 intrinsic matrix
    Matrix33 K(fx, skew, cx,
               0, fy, cy,
               0, 0, 1);

    /// Loop over all 3D points and project each point onto the image plane
    for (std::size_t i = 0; i < points_3d.size(); ++i) {
        const Vector3D &P = points_3d[i];
        /// This is how a 3D point is projected onto the image plane
        Vector3D proj = K * (R * P + t); /// this is in the homogeneous coordinate
        Vector2D p = proj.cartesian(); /// convert it to Cartesian coordinate
    }
}